local assets=
{ 
    Asset("ANIM", "anim/wand_bulldog6.zip"),
	Asset("ANIM", "anim/swap_wand_bulldog6.zip"),
    Asset("ATLAS", "images/inventoryimages/wand_bulldog6.xml"),
	Asset("IMAGE", "images/inventoryimages/wand_bulldog6.tex"),
}

local dam = 143

local function onattack_bulldog6(inst, owner, target)
    inst.SoundEmitter:PlaySound("shots/gunshot/bulldog6shot")	
	owner.components.inventory:ConsumeByName("vog25", 1)	
end

local function OnEquip(inst, owner) 
        owner.AnimState:OverrideSymbol("swap_object", "swap_wand_bulldog6", "wand")
        owner.AnimState:Show("ARM_carry") 
        owner.AnimState:Hide("ARM_normal") 
		owner.components.combat.min_attack_period = 1
end

local function OnUnequip(inst, owner) 
        owner.AnimState:Hide("ARM_carry") 
        owner.AnimState:Show("ARM_normal") 
		owner.components.combat.min_attack_period = 0
end



local function fn(colour)

	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
	inst.entity:AddSoundEmitter() 
    ---- 
    MakeInventoryPhysics(inst)
    
	
    anim:SetBank("wand")
    anim:SetBuild("wand_bulldog6")
    anim:PlayAnimation("idle")

	
	inst:AddComponent("weapon")
	inst.components.weapon:SetDamage(dam)
    inst.components.weapon:SetRange(19)
    inst.components.weapon:SetOnAttack(onattack_bulldog6)
    inst.components.weapon:SetProjectile("vog25")
		
	inst:AddComponent("inspectable")
		
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.imagename = "wand_bulldog6"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/wand_bulldog6.xml"
    
    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip( OnEquip )
    inst.components.equippable:SetOnUnequip( OnUnequip )
	
	inst.HasAmmo = function(inst, owner)
		if (owner and owner.components.inventory and owner.components.inventory:Has("vog25", 1)) or (owner:HasTag("ai")) then
			return true
		end
		return false
	end
	
    return inst
end

return  Prefab("common/inventory/wand_bulldog6", fn, assets)